-- events for main menu


function OnLoad ()
	SetProperty ("/HighScores:enter_trans_duration", 0.5);
	SetProperty ("/HighScores:leave_trans_duration", 0.5);
end;


function OnEnter ()
		-- set the active game mode
		num = GetGameByName ("AzkendQuestMode");
		Print ("Game Num is " .. num .. "\n");
		
		if (num == -1) then
			return;
		end;
		SetGame (num);	
end;

function OnLeave ()
end;


function OnClick (name)

	Print ("OnClick " .. name .. "\n");
	
	if (name == "Ok") then
		PopScreen ("HighScores");
		return;
	end;
	

end;


function OnUpdate (tdelta)

	akey = GetActiveScreenAnimKey ();

	trans = math.sin (0.5*3.1415926535 * GetActiveScreenTransPhase ());
	SetProperty ("heading:position_offset.y", (1-trans) * 600);
	-- SetProperty ("heading:alpha", trans);
	SetProperty ("fader:alpha", trans + trans * 0.05 * math.sin (2*3.141592*akey));


end;


function OnDraw ()

	alpha = GetActiveScreenTransPhase ();
	NX_SetAlpha (alpha);
	NX_SetColor (1,1,1);
	font = "fonts/small.mft";
	pos_x = GetProperty ("Scores:static_position.x");
	pos_y = GetProperty ("Scores:static_position.y");
	
	--NX_DrawText (font, 100, 100, "kraak " .. alpha);
	
	i = 1;
	while (i <= 10) do
		name = GetTotalScoreName (i);
		points = GetTotalScorePoints (i);
		time = GetTotalScoreTime (i);
		level = GetTotalScoreLevelShortName (i);

		NX_SetTextAlign ("TOPLEFT");		
		NX_SetColor (1,1,1);
		NX_DrawText (font, pos_x      , pos_y, i .. ".");
		NX_SetColor (1,0.6, 0.1);
		NX_DrawText (font, pos_x + 40 , pos_y, name);
		NX_SetColor (1,1,1);
		NX_DrawText (font, pos_x + 240, pos_y, level);
		NX_SetTextAlign ("TOPRIGHT");		
		NX_DrawText (font, pos_x + 380, pos_y, points);
		pos_y = pos_y + 26;
		i = i + 1;
	end;

	NX_SetColor (1,1,1);
	NX_SetTextAlign ("TOPLEFT");		

end;
